<?php



/*

* Enfold Child theme functions file

*/


/* adds the parent page in sidebar navigation */

function avia_sidebar_menu($echo = true)
{
	$sidebar_menu = "";

	$subNav = avia_get_option('page_nesting_nav');

	
	$the_id = @get_the_ID();
	$args 	= array();
	global $post;

	if($subNav && $subNav != 'disabled' && !empty($the_id) && is_page())
	{
		$subNav = false;
		$parent = $post->ID;
		$sidebar_menu = "";

		if (!empty($post->post_parent))
		{
			if(isset($post->ancestors)) $ancestors  = $post->ancestors;
			if(!isset($ancestors)) $ancestors  = get_post_ancestors($post->ID);
			$root		= count($ancestors)-1;
			$parent 	= $ancestors[$root];
		}

		$args = array('title_li'=>'', 'child_of'=>$parent, 'echo'=>0, 'sort_column'=>'menu_order, post_title');

		//enables user to change query args
		$args = apply_filters('avia_sidebar_menu_args', $args, $post);

		//hide or show child pages in menu - if the class is set to 'widget_nav_hide_child' the child pages will be hidden
		$display_child_pages = apply_filters('avia_sidebar_menu_display_child', 'widget_nav_hide_child', $args, $post);

		$children = wp_list_pages($args);

		if ($children)
		{
			$default_sidebar = false;
			$sidebar_menu .= "<a href='". get_the_permalink($parent) ."'>".get_the_title($parent)."</a>";
			$sidebar_menu .= "<nav class='widget widget_nav_menu $display_child_pages'><ul class='nested_nav'>";
			$sidebar_menu .= $children;
			$sidebar_menu .= "</ul></nav>";
		}
	}

	$sidebar_menu = apply_filters('avf_sidebar_menu_filter', $sidebar_menu, $args, $post);

	if($echo == true) { echo $sidebar_menu; } else { return $sidebar_menu; }
}

/* Adds a style bo in the builders */
add_theme_support('avia_template_builder_custom_css');

/* For Galexy Forms: returns position back to form location after submit */
add_filter( 'gform_confirmation_anchor', '__return_true' );


